﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Chapter_12
{
    public delegate decimal Calculation(decimal val1, decimal val2);

    class DelegateExample
    {
        public Calculation MyCalc;

        public decimal Add(decimal add1, decimal add2)
        {
            return add1 + add2;
        }

        static decimal capturedVar1 = 3.19m;

        static void Main(string[] args)
        {
            DelegateExample del = new DelegateExample();
            del.MyCalc = new Calculation(del.Add);

            // z wnioskowaniem delegacji
            del.MyCalc = del.Add;

            del.MyCalc = delegate(decimal add1, decimal add2)
            {
                return add1 + add2;
            };

            del.MyCalc = delegate { return 0; };

            var capturedVar2 = 9.71m;
            del.MyCalc = delegate { return capturedVar1 + capturedVar2; };

            decimal result = del.MyCalc(5.35m, 9.71m); // result = 15.06m

            Console.WriteLine(result);

            Console.ReadKey();
        }
    }
}
